#########################################################################
#	file: 			BinderCsv.t											#
#	description:	Csv file with binder in+out day						#
#	date:			040806												#
#	modified:		040806												#
#	Written By:		Mads Linden											#
#	(C) Copyright 1999 by The Electronic Farm Sweden.					#
#	(C) Copyright 2007 by Farmers Wife S.L..							#
#########################################################################

# Advanced / Enterprise ONLY

# creates a cvs file with a row for each binder in the project
# only binders with bookings or a static time range is exported

# structure / columns
# A = binder id
# B = parent binder id, so if not empty this holds the id of the parent
# C = name of binder
# D = first day
# E = last day

# define the seperator character
set SEP ","

# open a new file, using the session id for a unique name
set fileid [open [file join $::SYSTEM_PATH tmp_files $SESSION.csv] w]
fconfigure $fileid -translation binary


# start the loop on each binder
foreach row $BINDERLIST {
	puts $fileid \"[join $row \042${SEP}\042]\"
}

# close the file
close $fileid

# start excel
if {[catch {
	eval exec [auto_execok start] \"\" \"[file join $::SYSTEM_PATH tmp_files $SESSION.csv]\" &
} R1]} {
	# we could be on a mac
	catch {exec open "[file join $::SYSTEM_PATH tmp_files $SESSION.csv]"}
}

# shut down this script
wife::send exit $SESSION

